<?php

namespace App\Jobs;

use App\Models\Site;
use Illuminate\Bus\Queueable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Symfony\Component\BrowserKit\HttpBrowser;

class ExtractEmails implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected $url;
    protected $domain;

    public function __construct($url, Site $domain)
    {
        $this->url = $url;
        $this->domain = $domain;
    }

    public function handle()
    {
        $browser = new HttpBrowser();
        $browser->setServerParameter(
            'HTTP_USER_AGENT',
            'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/116.0.0.0 Safari/537.36'
        );
        $crawler = $browser->request('GET', $this->url);

        $container = $crawler->filter('body')->text();
        preg_match_all('/[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,}/', $container, $matches);

        foreach ($matches[0] as $email) {
            $this->domain->emails()->firstOrCreate([
                'email' => $email,
            ]);
        }
    }
}
