<?php

namespace App\Exports;

use App\Models\Mail;
use App\Models\Email;
use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\FromCollection;

class ExportEmail implements FromCollection, WithHeadings
{
    /**
    * @return \Illuminate\Support\Collection
    */
    public function collection()
    {

        return DB::table('emails')
        ->join('sites','emails.site_id','=','sites.id')
        ->select('emails.id', 'emails.email', 'sites.domain as site_domain')
        ->get();


    }

    public function headings(): array
    {
        return ["ID", "Email",'site_domain'];
    }
}
