<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\EmailController;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\ScrapingController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/', function () {
    return redirect()->route('login');
});

Route::get('dashboard',[ScrapingController::class,'index'])->middleware(['auth', 'verified'])->name('dashboard');

Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');

    // Route::get('sites',[ScrapingController::class,'index'])->name('scraping');
    Route::get('site/{site}',[ScrapingController::class,'view'])->name('site.view');

    Route::post('scraping',[ScrapingController::class,'links'])->name('scraping.domain');

    Route::get('emails',[EmailController::class,'index'])->name('emails');
    Route::get('exportEmails',[EmailController::class,'exportEmails'])->name('email.export');
    Route::get('test',[ScrapingController::class,'test']);

});

require __DIR__.'/auth.php';
