<?php

namespace App\Jobs;

use App\Models\Site;
use App\Models\Links;
use App\Jobs\ExtractEmails;
use Illuminate\Bus\Queueable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Symfony\Component\BrowserKit\HttpBrowser;

class ScrapingJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected $url;
    protected $domain;
    protected $pattern;

    public function __construct($url, Site $domain, $pattern)
    {
        $this->url = $url;
        $this->domain = $domain;
        $this->pattern = $pattern;
    }

    public function handle()
    {
            $browser = new HttpBrowser();
            $browser->setServerParameter(
                'HTTP_USER_AGENT',
                'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/116.0.0.0 Safari/537.36'
            );
            $crawler = $browser->request('GET', $this->url);
            $container = $crawler->filter('body');
            $tags = $container->filter('a')->each(function ($node) {
                $slug = $node->attr('href');                
                if (preg_match($this->pattern, $slug) && !preg_match('/\.pdf$/i', $slug) && $slug != $this->url && !Links::where('url', $slug)->exists()) {
                    return ['url' => $slug];
                }
            });
            $tags = array_values(array_filter($tags));
            $this->domain->links()->createMany($tags);

            foreach ($tags as $tag) {
                if(Links::where('url', $tag['url'])->where('excute',0)->exists()){
                    Links::where('url', $tag['url'])->update(['excute' => 1]);
                    dispatch(new self($tag['url'], $this->domain, $this->pattern));
                }

            }

            dispatch(new ExtractEmails($this->url, $this->domain));
    }
}
